/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.peripherals;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.GraphLocation;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.TrainEditPacket;
import com.simibubi.create.content.logistics.trains.management.schedule.Schedule;
import com.simibubi.create.foundation.networking.AllPackets;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrainPeripheral
implements IPeripheral {
    private static Schedule schedule;
    private final List<IComputerAccess> connectedComputers = new ArrayList<IComputerAccess>();
    private final Level level;
    private final StationTileEntity station;

    public TrainPeripheral(@NotNull BlockPos pos, Level level) {
        this.level = level;
        this.station = (StationTileEntity)level.m_7702_(pos);
    }

    @NotNull
    public String getType() {
        return "train_station";
    }

    @LuaFunction
    public final MethodResult assemble() {
        if (this.station.getStation().getPresentTrain() != null) {
            return MethodResult.of((Object[])new Object[]{false, "Train already assembled"});
        }
        if (this.station.tryEnterAssemblyMode()) {
            this.station.assemble(UUID.fromString("069a79f4-44e9-4726-a5be-fca90e38aaf5"));
            this.station.tick();
            if (schedule == null) {
                return MethodResult.of((Object[])new Object[]{true, "No schedule found"});
            }
            this.station.getStation().getPresentTrain().runtime.setSchedule(schedule, true);
            schedule = null;
            return MethodResult.of((Object[])new Object[]{true, "Train assembled"});
        }
        return MethodResult.of((Object[])new Object[]{false, "Could not assemble train"});
    }

    @LuaFunction
    public final MethodResult disassemble() {
        if (this.station.getStation().getPresentTrain() == null) {
            return MethodResult.of((Object[])new Object[]{false, "Train not assembled"});
        }
        if (this.station.getStation().getPresentTrain().canDisassemble()) {
            Direction direction = this.station.getAssemblyDirection();
            BlockPos position = this.station.edgePoint.getGlobalPosition().m_7494_();
            schedule = this.station.getStation().getPresentTrain().runtime.getSchedule();
            this.station.getStation().getPresentTrain().disassemble(direction, position);
            return MethodResult.of((Object[])new Object[]{true, "Train disassembled"});
        }
        return MethodResult.of((Object[])new Object[]{false, "Could not disassemble train"});
    }

    @LuaFunction
    public final String getStationName() {
        return this.station.getStation().name;
    }

    @LuaFunction
    public final String getTrainName() {
        return Objects.requireNonNull(this.station.getStation().getPresentTrain()).name.m_6111_();
    }

    @LuaFunction
    public final boolean setStationName(@NotNull String name) {
        GlobalStation station2 = this.station.getStation();
        GraphLocation graphLocation = this.station.edgePoint.determineGraphLocation();
        if (station2 != null && graphLocation != null) {
            station2.name = name;
            Create.RAILWAYS.sync.pointAdded(graphLocation.graph, (TrackEdgePoint)station2);
            Create.RAILWAYS.markTracksDirty();
            this.station.notifyUpdate();
            return true;
        }
        return false;
    }

    @LuaFunction
    public final MethodResult setTrainName(@NotNull String name) {
        if (this.station.getStation().getPresentTrain() == null) {
            return MethodResult.of((Object[])new Object[]{false, "There is no train to set the name of"});
        }
        Train train = this.station.getStation().getPresentTrain();
        Train Train2 = (Train)Create.RAILWAYS.sided((LevelAccessor)this.level).trains.get(train.id);
        if (Train2 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Train not found"});
        }
        if (!name.isBlank()) {
            Train2.name = new TextComponent(name);
            this.station.tick();
            AllPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)new TrainEditPacket.TrainEditReturnPacket(Train2.id, name, Train2.icon.getId()));
            return MethodResult.of((Object[])new Object[]{true, "Train name set to" + name});
        }
        return MethodResult.of((Object[])new Object[]{false, "Train name cannot be blank"});
    }

    @LuaFunction
    public final int getBogeys() {
        if (this.station.getStation().getPresentTrain() == null) {
            return 0;
        }
        return this.station.getStation().getPresentTrain().carriages.size();
    }

    @LuaFunction
    public final boolean getPresentTrain() {
        return this.station.getStation().getPresentTrain() != null;
    }

    @LuaFunction
    public final void clearSchedule() {
        schedule = null;
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return this == iPeripheral;
    }
}

